package handler

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"
	"signdemo/internal/logic"
	"signdemo/internal/svc"
	"signdemo/internal/types"
)

func SignDemoHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.SignDemoReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := logic.NewSignDemoLogic(r.Context(), svcCtx)
		resp, err := l.SignDemo(&req)
		if err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
